# 静的サイトを CMS 化するためのサンプルデータ

2025-08-19 版

サイトの構成は以下のようになっています。

* index.html（トップページ。メインビジュアルとサービス紹介があり、下部に「お知らせ一覧」が掲載されています）
* news/
  * index.html（お知らせ一覧ページ）
  * page2.html（お知らせ一覧の 2 ページ目）
  * 20250710.html 〜 20250807.html（5 つのお知らせ詳細ページ）
* service/
  * index.html（サービス一覧ページ）
  * catering.html, cooking-class.html, private-chef.html（各サービス紹介ページ） 
* contact/ （フォームは画面の遷移のみで動作していません）
  * index.html（お問い合わせフォーム）
  * confirm.html（確認画面）
  * thanks.html（送信完了画面）
* css/custom.css（Tailwind のカスタマイズや追加スタイルをまとめた CSS）
* images/（サイト内で使用するメインビジュアルや記事用画像が格納されています）

チュートリアルでは、このうち **トップページの「お知らせ一覧」 と お知らせの詳細ページ（news フォルダ内の HTML）** を題材に、静的 HTML を CMS 管理に置き換える流れを学びます。 まずは **「お知らせ部分を CMS化する」** ことで、手軽に「できた！」という達成感を体験しましょう。


### 相対パスとルート相対パスについて

HTML を CMS のテーマとして利用する際、画像や CSS へのパス指定方法によっては、表示が崩れることがあります。ここでは、相対パスとルート相対パスの違いを確認しておきましょう。

サンプルファイルには、相対パス版のファイルとルート相対パスの両方が同梱されています。

#### 相対パス (sample-relative-path)

現在のファイルを基準にして、そこから見た相対的な位置を指定する方法です。

```
<link rel="stylesheet" href="../css/custom.css">
<img src="./images/logo.png">
```

* ../ は「1つ上の階層」を意味します。
* ページの階層が深くなると、../../ のように複雑になりやすい。
* パソコンでファイルを直接閲覧可能です。

#### ルート相対パス (sample-root-relative-path)

サイトのルート（ドメイン直下 /）を基準にして指定する方法です。

```
<link rel="stylesheet" href="/css/custom.css">
<img src="/images/logo.png">
```

* どのディレクトリにあるページからでも同じ指定が使える。
* CMS 化したときに、テンプレートの場所に関わらず一貫して参照できる のでおすすめ。
* ウェブサーバーのドキュメントルートにアップロードして閲覧が可能になります。

既存の静的 HTML サイトを CMS 化する場合、すでに用意されている HTML は 相対パス で書かれているケースが多いと思われます。
a-blog cms では相対パスでも動作しますので、**どちらを使っても問題ありません。**

ただし、これから新しくコーディングを行うサイトであれば、担当者には 「**ルート相対パスでお願いします**」 と伝えておくことをおすすめします。

ルート相対パスを使うことで、テンプレートの階層や呼び出し場所に依存せず、どのページからも一貫して正しく参照できる だけでなく、後からファイル構成を整理して階層を移動した場合でもパスが変わってしまう心配が少なくなり、のちのち実装が楽になります。

**sample-root-relative-path フォルダをアップロード前に、sample にリネームしてご利用ください。**