<?php

/**
 * php/ACMS/User/Corrector.php
 * 校正オプションにユーザー定義のメソッドを追加します
 *
 * ユーザー定義のメソッドが優先されます。
 * ユーザー定義の関数を利用する場合は、所定の位置にこのファイルをコピーまたは作成します。
 * 所定位置に存在しなければ、このファイルは読み込まれません。
 *
 * @package ACMS
 */
class ACMS_User_Corrector
{
    /**
     * sample
     * 校正オプションのサンプルメソッド
     *
     * @param  string $txt  - 校正オプションが適用されている文字列
     * @param  array  $args - 校正オプションの引数　{var}[sample('ここの値')]
     * @return string       - 校正後の文字列
     */
    public static function sample($txt, $args = array())
    {
        // 例 {var}[sample('hoge','fuga')]
        // {var}の中は，'a-blogcms' とする

        $hoge = isset($args[0]) ? $args[0] : null; // 'hoge'
        $fuga = isset($args[1]) ? $args[1] : null; // 'fuga'

        return $hoge.$fuga.'+'.$txt; // 'hogefuga+a-blog cms'
    }
    function comma2break($txt)
    {
        $str = str_replace(",", "<br>", $txt);
        return $str;
    }

    function comma2list($txt)
    {
        $list   = explode(',', $txt);

        if ( is_array($list) && count($list) > 1 ) {
            $txt = '<ul>';
            foreach ( $list as $i => $val ) {
                $txt = $txt.'<li>'.$val.'</li>';
            }
            $txt .= '</ul>';
        }
        return $txt;
    }
}

