<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>a-blog cms インストーラー (Windows XAMPP版)</title>
</head>
<body>
<?php

set_time_limit(0);

// --------------------------
//
// Windows XAMPP用 a-blog cms 2.7.8 簡単セットアップ
//
// --------------------------

$dbHost     = 'localhost';
$dbName     = 'DBacms';
$dbCreate   = 'checked';
$dbUser     = 'root';
$dbPass     = '';

// --------------------------
// a-blog cms Ver. 2.7.8 設定
// --------------------------

# ダウンロード元 URL
$download55 = "http://developer.a-blogcms.jp/_package/2.7.8/acms2.7.8_php5.3.zip";
$download56 = "http://developer.a-blogcms.jp/_package/2.7.8/acms2.7.8_php5.6.zip";

# ダウンロード後のZipファイル名
$zipFile = "./acms_install.zip";

# 解凍後の全体フォルダ名
$zipAfterDirName55 = "acms2.7.8_php5.3";
$zipAfterDirName56 = "acms2.7.8_php5.6";

# 解凍後の a-blog cms のフォルダ名
$cmsDirName = "ablogcms";

# ioncube Loader ダウンロード元 URL
$downloadIoncube32 = "http://downloads3.ioncube.com/loader_downloads/ioncube_loaders_win_vc11_x86.zip";
$downloadIoncube64 = "http://downloads3.ioncube.com/loader_downloads/ioncube_loaders_win_vc11_x86-64.zip";

# ioncube Loader ダウンロード後のZipファイル名
$zipFileIoncube ="ioncube.zip";

$installPath = realpath('.');

$phpName = basename($_SERVER['PHP_SELF']);

// --------------------------
// バージョンのチェック
// --------------------------

$versionArray = explode(".", phpversion());
$version = $versionArray[0].".".$versionArray[1];

if ($versionArray[0] == 7 && $versionArray[1] == 1) {
	echo '<p style="text-align:center; margin-top:100px">現在、a-blog cms は PHP 7.1 に対応しておりません。XAMPP の設定... から PHP のバージョンを変更ください。</p>';
	exit;
}
if ($versionArray[0] == 7 && $versionArray[1] == 0) {
   $download = $download56;
   $zipAfterDirName = $zipAfterDirName56;
} elseif ($versionArray[1] >= 6) {
    $download = $download56;
    $zipAfterDirName = $zipAfterDirName56;
} else {
    $download = $download55;
    $zipAfterDirName = $zipAfterDirName55;
}

if (PHP_INT_SIZE == 4) {
	$downloadIoncube = $downloadIoncube32;
} else {
	$downloadIoncube = $downloadIoncube64;
}

$ablogcmsDir = $installPath."/".$zipAfterDirName."/".$cmsDirName."/";

// --------------------------
// a-blog cms ファイルをダウンロード
// --------------------------

$fp = fopen($download, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFile, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFile, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'a-blog cms download Error ! : '.$download;
    exit;
}

// --------------------------
// a-blog cms ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFile);

if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'a-blog cms unZip Error ! : '. $zipFile;
    exit;
}

// --------------------------
// a-blog cms ディレクトリを移動
// --------------------------

# index.php があった時にリネームしておく
if (is_file("./index.php")) {
    rename("./index.php", "_index.php");
}

if ($handle = opendir($ablogcmsDir)) {
    while(false !== ($entry = readdir($handle))) {
        if ($entry != "." && $entry != "..") {
             rename($ablogcmsDir.$entry, $installPath ."/". $entry);
        }
    }
    closedir($handle);
} else {
    echo 'a-blog cms move Error ! :'.$ablogcmsDir;
    exit;
}

// --------------------------
// ioncube ファイルをダウンロード
// --------------------------

$fp = fopen($downloadIoncube, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFileIoncube, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFileIoncube, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'ioncube loader download Error ! : '.$download;
    exit;
}

// --------------------------
// ioncube ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFileIoncube);

if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'ioncube loader unZip Error ! : '. $zipFileIoncube;
    exit;
}

// --------------------------
// php.ini の設定
// --------------------------

# php.ini のパスを設定する
$phpiniDir = explode("\htdocs",$installPath);
$iniFile = $phpiniDir[0]."\php\php.ini";

# 追記する設定内容
$iniData = sprintf("\r\n\r\ndate.timezone = 'Asia/Tokyo'\r\n\r\nzend_extension = \"%s\ioncube\ioncube_loader_win_5.%d.dll\"",$installPath,$versionArray[1]);

$file = file_get_contents($iniFile);

if (preg_match("/ioncube_loader/i", $file)) {

	# 設定済み

} else {
	$file = fopen( $iniFile, "a+" );
	fwrite( $file, $iniData );
	fclose( $file );
}

// --------------------------
// .htaccess の設定
// --------------------------

if ( is_file($installPath."/htaccess.txt") ) {
	rename($installPath."/htaccess.txt", $installPath.'/.htaccess');
}

// --------------------------
// DB 初期設定
// --------------------------

$data = sprintf("<?php
\$dbDefaultHost     = '%s';
\$dbDefaultName     = '%s';
\$dbDefaultCreate   = '%s'; // '' or 'checked'
\$dbDefaultUser     = '%s';
\$dbDefaultPass     = '%s';
\$dbDefaultPrefix   = 'acms_';",$dbHost,$dbName,$dbCreate,$dbUser,$dbPass);
$db_default = $installPath."/setup/lib/db_default.php";
file_put_contents($db_default, $data);

// --------------------------
// ファイルの削除
// --------------------------

if ( is_file($zipFile) ) unlink($zipFile);
if ( is_file($zipFileIoncube) ) unlink($zipFileIoncube);
if ( is_file($phpName) ) unlink($phpName);

if ( is_file($installPath."/ioncube/loader-wizard.php") ) unlink($installPath."/ioncube/loader-wizard.php");

# プログラム以外のディレクトリを削除
dir_shori ("delete", $zipAfterDirName);

// --------------------------
// インストーラーに飛ぶ
// --------------------------

$jump = "http://".$_SERVER['HTTP_HOST'].str_replace($phpName, "", $_SERVER['SCRIPT_NAME']);
echo sprintf('<p style="text-align:center; margin-top:100px">XAMPPを再起動して <a href="%s">%s</a> にアクセスしてください。</p>',$jump,$jump);

// --------------------------
// ディレクトリを操作 function ( move / copy / delete )
// --------------------------

function dir_shori ($shori, $nowDir , $newDir="") {

  if ($shori != "delete") {
    if (!is_dir($newDir)) {
      mkdir($newDir); 
    }
  }

  if (is_dir($nowDir)) {
    if ($handle = opendir($nowDir)) {
      while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
          if ($shori == "copy") {
            if (is_dir($nowDir."/".$file)) {
              dir_shori("copy", $nowDir."/".$file, $newDir."/".$file);
            } else {
              copy($nowDir."/".$file, $newDir."/".$file); 
            }
          } elseif ($shori == "move") {
            rename($nowDir."/".$file, $newDir."/".$file);
          } elseif ($shori == "delete") {
            if (filetype($nowDir."/".$file) == "dir") {
              dir_shori("delete", $nowDir."/".$file, ""); 
            } else {
              unlink($nowDir."/".$file); 
            } 
          }
        }
      }
      closedir($handle);
    }
  }

  if ($shori == "move" || $shori == "delete") {
    rmdir($nowDir);
  }

  return true;
}

?>
</body>
</html>