<?php

// --------------------------
//
// ヘテムル用 a-blog cms 2.7.7 簡単セットアップ
//
// --------------------------


# PHP のバージョンを 5.6 に指定
# $phpVersion = "5.6";

# インストーラー の
# MySQL の設定を事前に行う場合に
# ここを設定してください。

$dbHost     = 'mysql@@@.heteml.jp';
$dbName     = '';
$dbUser     = '';
$dbPass     = '';

// --------------------------
// a-blog cms Ver. 2.7.7 設定
// --------------------------

# ダウンロード元 URL
$download55 = "https://developer.a-blogcms.jp/_package/2.7.7/acms2.7.7_php5.3.zip";
$download56 = "https://developer.a-blogcms.jp/_package/2.7.7/acms2.7.7_php5.6.zip";

# ダウンロード後のZipファイル名
$zipFile = "./acms_install.zip";

# 解凍後の全体フォルダ名
$zipAfterDirName55 = "acms2.7.7_php5.3";
$zipAfterDirName56 = "acms2.7.7_php5.6";

# 解凍後の a-blog cms のフォルダ名
$cmsDirName = "ablogcms";

$installPath = realpath('.');

$phpName = basename($_SERVER['PHP_SELF']);

// --------------------------
// バージョンのチェック
// --------------------------

$versionArray = explode(".", phpversion());
$version = $versionArray[0].".".$versionArray[1];

if ($versionArray[0] == 7) { 
    $download = $download56;
    $zipAfterDirName = $zipAfterDirName56;
    $htaccessPlus = "AddHandler php7.0-script .php";
} elseif ($versionArray[1] == 6) { 
    $download = $download56;
    $zipAfterDirName = $zipAfterDirName56;
    $htaccessPlus = "AddHandler php5.6-script .php";
} else { 
    $download = $download55;
    $zipAfterDirName = $zipAfterDirName55;
    $htaccessPlus = "";
}

if (isset($phpVersion)) {

  switch ($php_version) {

    case "7.0":
      $download = $download56;
      $zipAfterDirName = $zipAfterDirName56;
      $htaccessPlus = "AddHandler php7.0-script .php";
      break;
    
    case "5.6":
      $download = $download56;
      $zipAfterDirName = $zipAfterDirName56;
      $htaccessPlus = "AddHandler php5.6-script .php";
      break;

    case "5.4":
      $download = $download55;
      $zipAfterDirName = $zipAfterDirName55;
      $htaccessPlus = "AddHandler php5.4-script .php";
      break;

    case "5.3":
      $download = $download55;
      $zipAfterDirName = $zipAfterDirName55;
      $htaccessPlus = "AddHandler php5.3-script .php";
      break;

  }
}

$ablogcmsDir = $installPath."/".$zipAfterDirName."/".$cmsDirName."/";

// --------------------------
// a-blog cms ファイルをダウンロード
// --------------------------

$fp = fopen($download, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFile, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFile, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'a-blog cms download Error ! : '.$download;
    exit;
}

// --------------------------
// a-blog cms ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFile);
 
if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'a-blog cms unZip Error ! : '. $zipFile;
    exit;
}

// --------------------------
// a-blog cms ディレクトリを移動
// --------------------------

if ($handle = opendir($ablogcmsDir)) {
    while(false !== ($entry = readdir($handle))) {
        if ($entry != "." && $entry != "..") {
             rename($ablogcmsDir.$entry, $installPath ."/". $entry);
        }
    }
    closedir($handle);
} else {
    echo 'a-blog cms move Error ! :'.$ablogcmsDir;
    exit;
}

// --------------------------
// .htaccess の設定
// --------------------------

if (is_file($installPath."/.htaccess")) {
  # .htaccess があった場合にはバックアップ
  rename($installPath."/.htaccess", $installPath.'/.htaccess_backup'.date("YmdHis"));
}

rename($installPath."/htaccess.txt", $installPath.'/.htaccess');

if ($htaccessPlus != "") {
  $htaccess = file_get_contents($installPath.'/.htaccess');
  $htaccess = $htaccessPlus . "\n\n" . $htaccess;
  file_put_contents($installPath.'/.htaccess', $htaccess);
}

rename($installPath."/archives/htaccess.txt", $installPath.'/archives/.htaccess');
rename($installPath."/archives_rev/htaccess.txt", $installPath.'/archives_rev/.htaccess');
rename($installPath."/media/htaccess.txt", $installPath.'/media/.htaccess');
rename($installPath."/private/htaccess.txt", $installPath.'/private/.htaccess');
rename($installPath."/themes/htaccess.txt", $installPath.'/themes/.htaccess');

// --------------------------
// DB 初期設定
// --------------------------

$data = sprintf("<?php
\$dbDefaultHost     = '%s';
\$dbDefaultName     = '%s';
\$dbDefaultCreate   = ''; // '' or 'checked'
\$dbDefaultUser     = '%s';
\$dbDefaultPass     = '%s';
\$dbDefaultPrefix   = 'acms_';",$dbHost,$dbName,$dbUser,$dbPass);

$db_default = $installPath."/setup/lib/db_default.php";
file_put_contents($db_default, $data);

// --------------------------
// ファイルの削除
// --------------------------

unlink($zipFile);
unlink($phpName);

# index.html があった時にリネームしておく
if (is_file("./index.html")) {
    rename("./index.html", "_index.html");
}

# プログラム以外のディレクトリを削除
dir_shori("delete", $zipAfterDirName);

// --------------------------
// インストーラーに飛ぶ
// --------------------------

$jump = str_replace($phpName, "", $_SERVER['SCRIPT_NAME']);
header("Location: " . $jump);


// --------------------------
// ディレクトリを操作 function ( move / copy / delete )
// --------------------------
function dir_shori ($shori, $nowDir , $newDir="") {
  if ($shori != "delete") {
    if (!is_dir($newDir)) {
      mkdir($newDir); 
    }
  }
  if (is_dir($nowDir)) {
    if ($handle = opendir($nowDir)) {
      while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
          if ($shori == "copy") {
            if (is_dir($nowDir."/".$file)) {
              dir_shori("copy", $nowDir."/".$file, $newDir."/".$file);
            } else {
              copy($nowDir."/".$file, $newDir."/".$file); 
            }
          } elseif ($shori == "move") {
            rename($nowDir."/".$file, $newDir."/".$file);
          } elseif ($shori == "delete") {
            if (filetype($nowDir."/".$file) == "dir") {
              dir_shori("delete", $nowDir."/".$file, ""); 
            } else {
              unlink($nowDir."/".$file); 
            } 
          }
        }
      }
      closedir($handle);
    }
  }
  if ($shori == "move" || $shori == "delete") {
    rmdir($nowDir);
  }
  return true;
}