<?php

// --------------------------
//
// a-blog cms 2.x -> 2.7.6 update
//
// --------------------------

$cmsVersion = "276";

# 利用しているテーマを指定します。
# 複数あれば | で区切って指定してください。
# 継承しているテーマは全て含まれます。

#$useThemes = "blog2016"; # "site2015|blog2015";

// --------------------------
// a-blog cms 
// --------------------------

# ダウンロード元 URL
$download55 = "http://developer.a-blogcms.jp/_package/2.7.6/acms2.7.6_update2x_php5.3.zip";
$download56 = "http://developer.a-blogcms.jp/_package/2.7.6/acms2.7.6_update2x_php5.6.zip";

# ダウンロード後のZipファイル名
$zipFile = "./acms.zip";

# 解凍後の全体フォルダ名
$zipAfterDirName55 = "acms2.7.6_update2x_php5.3";
$zipAfterDirName56 = "acms2.7.6_update2x_php5.6";

# 解凍後の a-blog cms のフォルダ名
$cmsDirName = "ablogcms";

// --------------------------
// バージョンチェック
// --------------------------

$versionArray = explode(".", phpversion());
$version = $versionArray[0].".".$versionArray[1];


if ($versionArray[0] == 7) {
    if ($versionArray[1] >= 1) { 
      echo 'php 7.1 is not supported.';
      exit;
    }
    $download = $download56;
    $zipAfterDirName = $zipAfterDirName56;
} elseif ($versionArray[1] >= 6) { 
    $download = $download56;
    $zipAfterDirName = $zipAfterDirName56;
} else { 
    $download = $download55;
    $zipAfterDirName = $zipAfterDirName55;
}

$installPath = realpath('.');
$ablogcmsDir = $installPath."/".$zipAfterDirName."/".$cmsDirName;
$phpName = basename($_SERVER['PHP_SELF']);

// --------------------------
// a-blog cms ファイルをダウンロード
// --------------------------

$fp = fopen($download, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFile, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFile, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'a-blog cms download Error ! : '.$download;
    exit;
}

// --------------------------
// a-blog cms ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFile);
 
if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'a-blog cms unZip Error ! : '. $zipFile;
    exit;
}

// --------------------------
// バックアップ
// --------------------------

$backupDir = "backup_".date("YmdHis"); # = "backup_20151227102900";

# バックアップディレクトリを作成
mkdir($backupDir);

# ファイルを移動
if (is_file("./acms.js")) rename("./acms.js", $backupDir."/acms.js");
if (is_file("./index.js")) rename("./index.js", $backupDir."/index.js");
if (is_file("./500.html")) rename("./500.html", $backupDir."/500.html");
rename("./index.php", $backupDir."/index.php");

# ディレクトリを移動

dir_shori("move", "./js", $backupDir."/js");
dir_shori("move", "./lang", $backupDir."/lang");
dir_shori("move", "./php", $backupDir."/php");
dir_shori("move", "./private", $backupDir."/private");
dir_shori("move", "./themes", $backupDir."/themes");

if (is_dir("./cache")) dir_shori("move", "./cache", $backupDir."/cache");

// --------------------------
// update版 ファイル＆ディレクトリを移動
// --------------------------

dir_shori("move", $ablogcmsDir, $installPath);

# 運用中のものを利用するので新しいファイルは削除
unlink($installPath ."/htaccess.txt");

// --------------------------
// カスタマイズ部分を戻す
// --------------------------

# themes を戻す
if (isset($useThemes)) {
if ($handle = opendir($backupDir."/themes")) {
  while(false !== ($theme = readdir($handle))) {
    if ($theme != "." && $theme != "..") {
      if (preg_match("/".$useThemes."/", $theme)) {
        if (is_dir("./themes/".$theme)) {
        	rename ("./themes/".$theme, "./themes/".$theme."_".$cmsVersion);
        }
        dir_shori ("copy", $backupDir."/themes/".$theme, "./themes/".$theme);
      } 
    }
  }
  closedir($handle);
} 
}

# /php/ACMS/User を戻す
rename ("./php/ACMS/User","./php/ACMS/User_".$cmsVersion);
dir_shori ("copy", $backupDir."/php/ACMS/User", "./php/ACMS/User");        

# php/AAPP を戻す
rename ("./php/AAPP", "./php/AAPP_".$cmsVersion);
dir_shori ("copy", $backupDir."/php/AAPP", "./php/AAPP");  

# /private/config.system.yaml を戻す
rename ("./private/config.system.yaml", "./private/config.system_".$cmsVersion.".yaml");
copy ($backupDir."/private/config.system.yaml", "./private/config.system.yaml");  


// --------------------------
// .htaccess の設定
// --------------------------
rename("./private/htaccess.txt", './private/.htaccess');
rename("./themes/htaccess.txt", './themes/.htaccess');
rename("./cache/htaccess.txt", './cache/.htaccess');

// --------------------------
// php.ini があった時の処理
// --------------------------

if ( is_file( "./php.ini" )) {
    copy("./php.ini", "./setup/php.ini");
}

// --------------------------
// ファイルの削除
// --------------------------

unlink($zipFile);
unlink($phpName);

# プログラム以外のディレクトリを削除
dir_shori("delete", $zipAfterDirName);

// --------------------------
// インストーラーに飛ぶ
// --------------------------

$jump = str_replace($phpName, "", $_SERVER['SCRIPT_NAME']);
header("Location: " . $jump);

// --------------------------
// ディレクトリを操作 function ( move / copy / delete )
// --------------------------

function dir_shori ($shori, $nowDir , $newDir="") {

  if ($shori != "delete") {
    if (!is_dir($newDir)) {
      mkdir($newDir); 
    }
  }

  if (is_dir($nowDir)) {
    if ($handle = opendir($nowDir)) {
      while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
          if ($shori == "copy") {
            if (is_dir($nowDir."/".$file)) {
              dir_shori("copy", $nowDir."/".$file, $newDir."/".$file);
            } else {
              copy($nowDir."/".$file, $newDir."/".$file); 
            }
          } elseif ($shori == "move") {
            rename($nowDir."/".$file, $newDir."/".$file);
          } elseif ($shori == "delete") {
            if (filetype($nowDir."/".$file) == "dir") {
              dir_shori("delete", $nowDir."/".$file, ""); 
            } else {
              unlink($nowDir."/".$file); 
            } 
          }
        }
      }
      closedir($handle);
    }
  }

  if ($shori == "move" || $shori == "delete") {
    rmdir($nowDir);
  }

  return true;
}