<!DOCTYPE HTML>
<html lang="ja">
<head>
<meta charset="UTF-8">
<title>a-blog cms インストーラー (MAMP版)</title>
</head>
<body>
<?php

set_time_limit(0);


// --------------------------
// インストールする a-blog cms バージョン
// --------------------------

$ablogcmsVersion = '2.7.0';
//$ablogcmsVersion = '2.6.1.4';
//$ablogcmsVersion = '2.5.1.3';
//$ablogcmsVersion = '2.1.1.4';
//$ablogcmsVersion = '2.0.1.1';


// --------------------------
// a-blog cms Ver. 2.0 各バージョン情報
// --------------------------

$acms = array(
    "2.0.0" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1i0eZEy",
            "folder" => "acms200"),
        "5.4" => array(
            "download" => "http://ablogc.ms/1i0eZEy",
            "folder" => "acms200"),   
        ),
    "2.0.0.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1fKMzLt",
            "folder" => "acms2001"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1fKMzLt",
            "folder" => "acms2001")
        ),
    "2.0.0.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1lZ26LB",
            "folder" => "acms2002install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1lZ26LB",
            "folder" => "acms2002install")
        ),
    "2.0.0.3" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1csPvYV",
            "folder" => "acms2003install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1csPvYV",
            "folder" => "acms2003install")
        ),
    "2.0.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1d7mkL9",
            "folder" => "acms201install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1d7mkL9",
            "folder" => "acms201install")
        ),
    "2.0.1.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1bZMal6",
            "folder" => "acms2011install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1bZMal6",
            "folder" => "acms2011install")
        ),
    "2.1.0" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/Uy9GmT",
            "folder" => "acms210_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/Uy9GmT",
            "folder" => "acms210_install")
        ),
    "2.1.0.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1jXxcQB",
            "folder" => "acms2101_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1jXxcQB",
            "folder" => "acms2101_install")
        ),
    "2.1.0.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1ptYUpZ",
            "folder" => "acms2102_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1ptYUpZ",
            "folder" => "acms2102_install")
        ),
    "2.1.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1lS5jzQ",
            "folder" => "acms211_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1lS5jzQ",
            "folder" => "acms211_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1AsvIoS",
            "folder" => "acms211_install_55"),
        ),
    "2.1.1.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1xddzOQ",
            "folder" => "acms2111_install"),
        "5.4" => array (
            "download" => "ablogc",
            "folder" => "acms2111_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1qta6TE",
            "folder" => "acms2111_install_php55"),
        ),
    "2.1.1.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/129NDpL",
            "folder" => "acms2112_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/129NDpL",
            "folder" => "acms2112_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1vs7xIo",
            "folder" => "acms2112_install"),
        ),
    "2.1.1.3" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1zv2eIS",
            "folder" => "acms2113_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1zv2eIS",
            "folder" => "acms2113_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/13b2MI0",
            "folder" => "acms2113_install"),
        ),
    "2.1.1.4" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1KRuzyl",
            "folder" => "acms2114_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1KRuzyl",
            "folder" => "acms2114_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1B5nxnZ",
            "folder" => "acms2114_install"),
        ),
    "2.5.0" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/acms250_54",
            "folder" => "acms250_install_php54"),
        "5.4" => array (
            "download" => "http://ablogc.ms/acms250_54",
            "folder" => "acms250_install_php54"),
        "5.5" => array (
            "download" => "http://ablogc.ms/acms250",
            "folder" => "acms250_install"),
        ),
    "2.5.0.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/php54x_2501_install",
            "folder" => "acms2501_install_php54"),
        "5.4" => array (
            "download" => "http://ablogc.ms/php54x_2501_install",
            "folder" => "acms2501_install_php54"),
        "5.5" => array (
            "download" => "http://ablogc.ms/php55x_2501_install",
            "folder" => "acms2501_install"),
        ),
    "2.5.0.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/php54x_2502_install",
            "folder" => "acms2502_install_php54"),
        "5.4" => array (
            "download" => "http://ablogc.ms/php54x_2502_install",
            "folder" => "acms2502_install_php54"),
        "5.5" => array (
            "download" => "http://ablogc.ms/php55x_2502_install",
            "folder" => "acms2502_install"),
        ),
    "2.5.0.3" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1KfYlxS",
            "folder" => "release-2503_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1KfYlxS",
            "folder" => "release-2503_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1FzEog4",
            "folder" => "release-2503_install"),
        ),
    "2.5.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1Hv6ucj",
            "folder" => "acms251_install_php54"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1Hv6ucj",
            "folder" => "acms251_install_php54"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1PajLNF",
            "folder" => "acms251_install"),
        ),
    "2.5.1.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1E4v74s",
            "folder" => "acms2511_install_php54x"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1E4v74s",
            "folder" => "acms2511_install_php54x"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1UScsNV",
            "folder" => "acms2511_install"),
        ),
    "2.5.1.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1QcU6EF",
            "folder" => "acms2512_install_php54x"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1QcU6EF",
            "folder" => "acms2512_install_php54x"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1PPdqqC",
            "folder" => "acms2512_install"),
        ),

    "2.5.1.3" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/2513_install",
            "folder" => "acms2513_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/2513_install",
            "folder" => "acms2513_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/2513_install",
            "folder" => "acms2513_install"),
        ),
    "2.6.0" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1ZrDNbK",
            "folder" => "acms260_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1ZrDNbK",
            "folder" => "acms260_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1ZrDNbK",
            "folder" => "acms260_install"),
        "5.6" => array (
            "download" => "http://ablogc.ms/1PnmndI",
            "folder" => "acms260_install"),
        ),
    "2.6.0.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1SAJp2B",
            "folder" => "acms2601_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1SAJp2B",
            "folder" => "acms2601_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1SAJp2B",
            "folder" => "acms2601_install"),
        "5.6" => array (
            "download" => "http://ablogc.ms/1RCDcTC",
            "folder" => "acms2601_install"),
        ),
    "2.6.0.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/1McmZ6v",
            "folder" => "acms2602_install"),
        "5.4" => array (
            "download" => "http://ablogc.ms/1McmZ6v",
            "folder" => "acms2602_install"),
        "5.5" => array (
            "download" => "http://ablogc.ms/1McmZ6v",
            "folder" => "acms2602_install"),
        "5.6" => array (
            "download" => "http://ablogc.ms/1MRodUF",
            "folder" => "acms2602_install"),
        ),
    "2.6.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/28Ofa3G",
            "folder" => "acms261_install_53x"),
        "5.4" => array (
            "download" => "http://ablogc.ms/28Ofa3G",
            "folder" => "acms261_install_53x"),
        "5.5" => array (
            "download" => "http://ablogc.ms/28Ofa3G",
            "folder" => "acms261_install_53x"),
        "5.6" => array (
            "download" => "http://ablogc.ms/28OV6Pu",
            "folder" => "acms261_install_56x"),
        ),
    "2.6.1.1" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/28S2uP1",
            "folder" => "acms2611_install_53x"),
        "5.4" => array (
            "download" => "http://ablogc.ms/28S2uP1",
            "folder" => "acms2611_install_53x"),
        "5.5" => array (
            "download" => "http://ablogc.ms/28S2uP1",
            "folder" => "acms2611_install_53x"),
        "5.6" => array (
            "download" => "http://ablogc.ms/28P4sil",
            "folder" => "acms2611_install_56x"),
        ),
    "2.6.1.2" => array(
        "5.3" => array(
            "download" => "http://ablogc.ms/29btqGH",
            "folder" => "acms2612_install_53x"),
        "5.4" => array (
            "download" => "http://ablogc.ms/29btqGH",
            "folder" => "acms2612_install_53x"),
        "5.5" => array (
            "download" => "http://ablogc.ms/29btqGH",
            "folder" => "acms2612_install_53x"),
        "5.6" => array (
            "download" => "http://ablogc.ms/295f5y5",
            "folder" => "acms2612_install_56x"),
        ),
    "2.6.1.3" => array(
        "5.3" => array(
            "download" => "https://www.a-blogcms.jp/_download/2613/php53x/acms2613_install_53x.zip",
            "folder" => "acms2613_install_53x"),
        "5.4" => array (
            "download" => "https://www.a-blogcms.jp/_download/2613/php53x/acms2613_install_53x.zip",
            "folder" => "acms2613_install_53x"),
        "5.5" => array (
            "download" => "https://www.a-blogcms.jp/_download/2613/php53x/acms2613_install_53x.zip",
            "folder" => "acms2613_install_53x"),
        "5.6" => array (
            "download" => "https://www.a-blogcms.jp/_download/2613/php56x/acms2613_install_56x.zip",
            "folder" => "acms2613_install_56x"),
        ),
     "2.6.1.4" => array(
        "5.3" => array(
            "download" => "https://www.a-blogcms.jp/_download/2614/php53x/acms2614_install_53x.zip",
            "folder" => "acms2614_install_53x"),
        "5.4" => array (
            "download" => "https://www.a-blogcms.jp/_download/2614/php53x/acms2614_install_53x.zip",
            "folder" => "acms2614_install_53x"),
        "5.5" => array (
            "download" => "https://www.a-blogcms.jp/_download/2614/php53x/acms2614_install_53x.zip",
            "folder" => "acms2614_install_53x"),
        "5.6" => array (
            "download" => "https://www.a-blogcms.jp/_download/2614/php56x/acms2614_install_56x.zip",
            "folder" => "acms2614_install_56x"),
        ),
    "2.7.0" => array(
        "5.3" => array(
            "download" => "https://www.a-blogcms.jp/_download/270/php53x/270_install_php53x.zip",
            "folder" => "270_install_php53x"),
        "5.4" => array (
            "download" => "https://www.a-blogcms.jp/_download/270/php53x/270_install_php53x.zip",
            "folder" => "270_install_php53x"),
        "5.5" => array (
            "download" => "https://www.a-blogcms.jp/_download/270/php53x/270_install_php53x.zip",
            "folder" => "270_install_php53x"),
        "5.6" => array (
            "download" => "https://www.a-blogcms.jp/_download/270/php56x/270_install_php56x.zip",
            "folder" => "270_install_php56x"),
        "7.0" => array (
            "download" => "https://www.a-blogcms.jp/_download/270/php56x/270_install_php56x.zip",
            "folder" => "270_install_php56x"),
        )
);



# 現在の PHP のバージョンを設定
$versionArray = explode(".", phpversion());
$version = $versionArray[0].".".$versionArray[1];


if (!is_array($acms[$ablogcmsVersion][$version])) {

    echo "<p>現在のPHPのバージョン(".$version.")で a-blog cms Ver.".$ablogcmsVersion." は用意されていません。</p>";
    exit;
}

# ダウンロード後のZipファイル名
$zipFile = "./ablogcms.zip";

# 解凍後の a-blog cms のフォルダ名
$cmsDirName = "ablogcms";

# ioncube Loader ダウンロード元 URL
$downloadIoncube = "http://downloads3.ioncube.com/loader_downloads/ioncube_loaders_dar_x86-64.zip";

# ioncube Loader ダウンロード後のZipファイル名
$zipFileIoncube ="ioncube.zip";

$installPath = realpath('.');

$phpName = basename($_SERVER['PHP_SELF']);

$download = $acms[$ablogcmsVersion][$version]['download'];
$zipAfterDirName = $acms[$ablogcmsVersion][$version]['folder'];

$ablogcmsDir = $installPath."/".$zipAfterDirName."/".$cmsDirName."/";

$ablogcmsVersionNum = str_replace(".", "", $ablogcmsVersion);

$mampRestart = "";

// --------------------------
// データベースの設定
// --------------------------

$dbHost     = 'localhost';
$dbName     = 'DBacms_'.$ablogcmsVersionNum."_".date(mdHi);
$dbCreate   = 'checked';
$dbUser     = 'root';
$dbPass     = 'root';

// --------------------------
// a-blog cms ファイルをダウンロード
// --------------------------

$fp = fopen($download, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFile, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFile, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'a-blog cms download Error ! : '.$download;
    exit;
}

// --------------------------
// a-blog cms ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFile);
 
if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'a-blog cms unZip Error ! : '. $zipFile;
    exit;
}

// --------------------------
// a-blog cms ディレクトリを移動
// --------------------------

if ($handle = opendir($ablogcmsDir)) {
    while(false !== ($entry = readdir($handle))) {
        if ($entry != "." && $entry != "..") {
             rename($ablogcmsDir.$entry, $installPath ."/". $entry);
        }
    }
    closedir($handle);
} else {
    echo 'a-blog cms move Error ! :'.$ablogcmsDir;
    exit;
}

// --------------------------
// ioncube Loader チェック
// --------------------------

$useIonCubeLoader = sprintf("ioncube_loader_dar_%d.%d.so",$versionArray[0],$versionArray[1]);

if (!is_file(PHP_EXTENSION_DIR."/".$useIonCubeLoader)) {


    // --------------------------
    // ioncube ファイルをダウンロード
    // --------------------------

    $fp = fopen($downloadIoncube, "r");
    if ($fp !== FALSE) {
        file_put_contents($zipFileIoncube, "");
        while(!feof($fp)) {
            $buffer = fread($fp, 4096);
            if ($buffer !== FALSE) {
                file_put_contents($zipFileIoncube, $buffer, FILE_APPEND);
            }
        }
        fclose($fp);
    } else {
        echo 'ioncube loader download Error ! : '.$download;
        exit;
    }

    // --------------------------
    // ioncube Loader ファイルを解凍
    // --------------------------

    $zip = new ZipArchive();
    $res = $zip->open($zipFileIoncube);
     
    if($res === true){
        $zip->extractTo($installPath);
        $zip->close();

    } else {
        echo 'ioncube loader unZip Error ! : '. $zipFileIoncube;
        exit;
    }

    // --------------------------
    // ioncube Loader ファイルを移動
    // --------------------------

    rename("./ioncube/".$useIonCubeLoader, PHP_EXTENSION_DIR."/".$useIonCubeLoader);

    // --------------------------
    // php.ini の設定
    // --------------------------

    # MAMP の php.ini のパスを設定する
    $iniFile = "/Applications/MAMP/bin/php/php".phpversion()."/conf/php.ini";

    # 追記する設定内容
    $iniData = sprintf("\n\ndate.timezone = 'Asia/Tokyo'\n\nzend_extension = \"%s/ioncube_loader_dar_%d.%d.so\"",PHP_EXTENSION_DIR ,$versionArray[0],$versionArray[1]);

    $file = file_get_contents($iniFile);

    if (preg_match("/ioncube_loader/i", $file)) {

      # 設定済み

    } else {
      $file = fopen( $iniFile, "a+" );
      fwrite( $file, $iniData );
      fclose( $file );
    }

    $mampRestart = "<strong>MAMPを再起動して</strong> ";

}


// --------------------------
// .htaccess の設定
// --------------------------

rename("./htaccess.txt", './.htaccess');
#rename("./archives/htaccess.txt", './archives/.htaccess');
#rename("./archives_rev/htaccess.txt", './archives_rev/.htaccess');
#rename("./private/htaccess.txt", './private/.htaccess');
#rename("./media/htaccess.txt", './media/.htaccess');
#rename("./theme/htaccess.txt", './theme/.htaccess');

// --------------------------
// DB 初期設定
// --------------------------

$data = sprintf("<?php
\$dbDefaultHost     = '%s';
\$dbDefaultName     = '%s';
\$dbDefaultCreate   = '%s'; // '' or 'checked'
\$dbDefaultUser     = '%s';
\$dbDefaultPass     = '%s';
\$dbDefaultPrefix   = 'acms_';",$dbHost,$dbName,$dbCreate,$dbUser,$dbPass);
$db_default = "./setup/lib/db_default.php";
file_put_contents($db_default, $data);

// --------------------------
// ファイルの削除
// --------------------------

unlink($zipFile);
unlink($zipFileIoncube);
unlink($phpName);

# index.html があった時にリネームしておく
if (is_file("./index.html")) {
    rename("./index.html", "_index.html");
}

# unlink($installPath."/ioncube/loader-wizard.php");
dir_shori ("delete", "ioncube");

# プログラム以外のディレクトリを削除
dir_shori ("delete", $zipAfterDirName);

// --------------------------
// インストーラーに飛ぶ
// --------------------------

echo sprintf('<p style="text-align:center; margin-top:100px">a-blog cms Ver %s ( php %s ) をインストールしました。</p>',$ablogcmsVersion,$version);

$jump = "http://".$_SERVER['HTTP_HOST'].str_replace($phpName, "", $_SERVER['SCRIPT_NAME']);
echo sprintf('<p style="text-align:center; margin-top:30px">%s<a href="%s">%s</a> にアクセスしてください。</p>',$mampRestart, $jump, $jump);

// --------------------------
// ディレクトリを操作 function ( move / copy / delete )
// --------------------------

function dir_shori ($shori, $nowDir , $newDir="") {

  if ($shori != "delete") {
    if (!is_dir($newDir)) {
      mkdir($newDir); 
    }
  }

  if (is_dir($nowDir)) {
    if ($handle = opendir($nowDir)) {
      while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
          if ($shori == "copy") {
            if (is_dir($nowDir."/".$file)) {
              dir_shori("copy", $nowDir."/".$file, $newDir."/".$file);
            } else {
              copy($nowDir."/".$file, $newDir."/".$file); 
            }
          } elseif ($shori == "move") {
            rename($nowDir."/".$file, $newDir."/".$file);
          } elseif ($shori == "delete") {
            if (filetype($nowDir."/".$file) == "dir") {
              dir_shori("delete", $nowDir."/".$file, ""); 
            } else {
              unlink($nowDir."/".$file); 
            } 
          }
        }
      }
      closedir($handle);
    }
  }

  if ($shori == "move" || $shori == "delete") {
    rmdir($nowDir);
  }

  return true;
}

?>
</body>
</html>