// gulpを導入
var gulp = require('gulp');

// 導入されているプラグイン
var browserSync = require('browser-sync').create(),
	rename = require('gulp-rename'),
	less = require('gulp-sass'),
	sass = require('gulp-sass'),
	path = require('path'),
	cssnano = require('gulp-cssnano'),
	watch = require('gulp-watch'),
	autoprefixer = require('gulp-autoprefixer'),
	csscomb = require('gulp-csscomb'),
	plumber = require('gulp-plumber'),
	sourcemaps = require('gulp-sourcemaps'),
	timestamp   = Date.now(),
	replace = require('gulp-replace'),
	header = require('gulp-header'),
	fs = require('fs'),
	pkg = require('./package.json'),
	fileHeader = '@charset "utf-8";\n'+
"/*\n"+
" * acms.css Ver.<%= pkg.css.version %> (<%= pkg.homepage %>)\n"+
" * Copyright a-blog cms | MIT License\n"+
" *\n"+
" * カスタマイズする場合は、オリジナルのテーマにコピーしてご利用ください。\n"+
" */\n";
var adminfileHeader = '@charset "utf-8";\n'+
"/*\n"+
" * acms-admin.css Ver.<%= pkg.css.version %> (http://www.a-blogcms.jp)\n"+
" * Copyright a-blog cms | MIT License\n"+
" *\n"+
" * 使用するテーマに関係なく必要なa-blog cmsのシステムに関わるスタイルの設定です。\n"+
" * このCSSファイルを適用しない場合、表示に問題が発生しますのでご注意ください。\n"+
" */\n";

// ローカル環境のIPアドレスの設定
var proxy = "localhost";

//CSSフレームワーク用のSCSSファイルをCSSにコンパイルする
gulp.task('acms-sass', function () {
	// 冒頭にCSSの情報を追加する
	var date = new Date();
	var version = "Ver."+pkg.css.version;
	var string = '更新日時: '+date.getFullYear()+'.'+("0" + (date.getMonth() + 1)).slice(-2)+'.'+("0" + date.getDate()).slice(-2);
	gulp.src(['themes/system/admin/styleguide/index.html'])
		.pipe(replace(/<p class="gulp\-version">.*?<\/p>/,'<p class="gulp-version">'+version+'</p>'))
		.pipe(replace(/<p class="gulp\-update">.*?<\/p>/,'<p class="gulp-update">'+string+'</p>'))
		.pipe(gulp.dest('themes/system/admin/styleguide'));
	// CSSにコンパイルする
	gulp.src(['themes/system/scss/acms.scss'])
		.pipe(plumber({
			handleError: function (err) {
				console.log(err);
				this.emit('end');
			}
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(replace('@charset "utf-8";\n',''))
		.pipe(header(fileHeader,{pkg:pkg}))
		.pipe(gulp.dest('themes/system/css'))
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/system/css'))
		.pipe(browserSync.stream());
});
// SCSSファイルを圧縮する
gulp.task('acms-sass-min', function () {
	// 冒頭にCSSの情報を追加する
	var date = new Date();
	var version = "Ver."+pkg.css.version;
	var string = '更新日時: '+date.getFullYear()+'.'+("0" + (date.getMonth() + 1)).slice(-2)+'.'+("0" + date.getDate()).slice(-2);
	gulp.src(['themes/system/admin/styleguide/index.html'])
		.pipe(replace(/<p class="gulp\-version">.*?<\/p>/,'<p class="gulp-version">'+version+'</p>'))
		.pipe(replace(/<p class="gulp\-update">.*?<\/p>/,'<p class="gulp-update">'+string+'</p>'))
		.pipe(gulp.dest('themes/system/admin/styleguide'));
	// CSSにコンパイルする
	gulp.src(['themes/system/scss/acms.scss'])
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(cssnano({safe: true}))//圧縮する
		.pipe(replace('@charset "utf-8";',''))
		.pipe(header(fileHeader,{pkg:pkg}))
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(rename({ // 圧縮したCSSはリネームする
			suffix: '.min'
		}))
		.pipe(gulp.dest('themes/system/css'))
		.pipe(browserSync.stream());
});


//Blog2016テーマ
//SCSSファイルをCSSにコンパイルする
gulp.task('blog2016sass', function () {
	gulp.src(['themes/blog2016/scss/blog2016.scss'])
		.pipe(plumber({
			handleError: function (err) {
				console.log(err);
				this.emit('end');
			}
		}))
		.pipe(sourcemaps.init()) // *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb()) // *1
		.pipe(sourcemaps.write('/maps'))
		.pipe(gulp.dest('themes/blog2016/css'))
		.pipe(browserSync.stream());// *2
});
// SCSSファイルを圧縮する
gulp.task('blog2016min', function () {
	gulp.src(['themes/blog2016/scss/blog2016.scss'])
		.pipe(rename({
			suffix: '.min'
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(cssnano({safe: true}))
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/blog2016/css'))
		.pipe(browserSync.stream());
});

//Site2016テーマ
//SCSSファイルをCSSにコンパイルする
gulp.task('site2016sass', function () {
	gulp.src(['themes/site2016/scss/site.scss'])
		.pipe(plumber({
			handleError: function (err) {
				console.log(err);
				this.emit('end');
			}
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/site2016/css'))
		.pipe(browserSync.stream());
});
// SCSSファイルを圧縮する
gulp.task('site2016min', function () {
	gulp.src(['themes/site2016/scss/site.scss'])
		.pipe(rename({
			suffix: '.min'
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(cssnano({safe: true}))
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/site2016/css'));
});

//Simple2016テーマ
//SCSSファイルをCSSにコンパイルする
gulp.task('simple2016sass', function () {
	gulp.src(['themes/simple2016/scss/site.scss'])
		.pipe(plumber({
			handleError: function (err) {
				console.log(err);
				this.emit('end');
			}
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/simple2016/css'))
		.pipe(browserSync.stream());
});
// SCSSファイルを圧縮する
gulp.task('simple2016min', function () {
	gulp.src(['themes/simple2016/scss/site.scss'])
		.pipe(rename({
			suffix: '.min'
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(cssnano({safe: true}))
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/simple2016/css'))
		.pipe(browserSync.stream());
});

//Bootstrap2016テーマ
//SCSSをCSSにコンパイルする
gulp.task('bootstrap2016sass', function () {
	gulp.src(['themes/bootstrap2016/scss/bootstrap2016.scss'])
		.pipe(plumber({
			handleError: function (err) {
				console.log(err);
				this.emit('end');
			}
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/bootstrap2016/css'))
		.pipe(rename({
			suffix: '.min'
		}))
		.pipe(cssnano({safe: true}))
		.pipe(gulp.dest('themes/bootstrap2016/css'))
		.pipe(browserSync.stream());
});
// SCSSファイルを圧縮する
gulp.task('bootstrap2016min', function () {
	gulp.src(['themes/bootstrap2016/scss/bootstrap2016.scss'])
		.pipe(rename({
			suffix: '.min'
		}))
		.pipe(sourcemaps.init())// *2
		.pipe(sass())
		.pipe(autoprefixer({
			browsers: ['last 2 versions', 'ie 9'],
			cascade: false
		}))
		// .pipe(csscomb())// *1
		.pipe(cssnano({safe: true}))
		.pipe(sourcemaps.write('/maps'))// *2
		.pipe(gulp.dest('themes/bootstrap2016/css'))
		.pipe(browserSync.stream());
});


//systemのLESSとCSSファイルを監視する
gulp.task('watch', function() {
	gulp.watch('themes/system/scss/*.scss', ['acms-sass','system-sass']);
	gulp.watch('themes/system/css/acms.css', ['acms-sass-min','system-sass-min']);
	// ファイルに変更があったらブラウザが自動的にリロードする設定
	browserSync.init({
		proxy: proxy
	});
});

//blog2016のLESSとCSSファイルを監視する
gulp.task('blog2016', function() {
	gulp.watch('themes/blog2016/scss/*.scss', ['blog2016sass']);
	gulp.watch('themes/blog2016/css/blog2016.css', ['blog2016min']);
	// ファイルに変更があったらブラウザが自動的にリロードする設定
	browserSync.init({
		proxy: proxy
	});
});

//site2016のLESSとCSSファイルを監視する
gulp.task('site2016', function() {
	gulp.watch('themes/site2016/scss/*.scss',['site2016sass']).on('change', browserSync.reload);
	gulp.watch('themes/site2016/css/site.css',['site2016min']);
	// ファイルに変更があったらブラウザが自動的にリロードする設定
	browserSync.init({
		proxy: proxy
	});
});

//simple2016のLESSとCSSファイルを監視する
gulp.task('simple2016', function() {
	gulp.watch('themes/simple2016/scss/*.scss',['simple2016sass']).on('change', browserSync.reload);
	gulp.watch('themes/simple2016/css/site.css',['simple2016min']);
	// ファイルに変更があったらブラウザが自動的にリロードする設定
	browserSync.init({
		proxy: proxy
	});
});

//bootstrap2016のLESSとCSSファイルを監視する
gulp.task('bootstrap2016', function() {
	gulp.watch('themes/bootstrap2016/scss/*.scss',['bootstrap2016sass']).on('change', browserSync.reload);
	gulp.watch('themes/bootstrap2016/css/boostrap2016.css',['bootstrap2016min']);
	// ファイルに変更があったらブラウザが自動的にリロードする設定
	browserSync.init({
		proxy: proxy
	});
});

// デフォルトのタスク
gulp.task('default', ['watch','blog2016','site2016','simple2016','bootstrap2016']);


// *1・*2 gulp-csscombとgulp-sourcemaps は、gulp-csscombがgulp-sourcemapsに対応していないので、同時に動作することができません。gulp-csscombを動作させたい場合は、「*2」の記述をコメントアウトしてください。
