<?php

// --------------------------
//
// a-blog cms 2.5.x -> 2.6.0.2 update
//
// --------------------------

$cmsVersion = "2602";

# 利用しているテーマを指定します。
# 複数あれば | で区切って指定してください。
# 継承しているテーマは全て含まれます。

#$useThemes = "site2015"; # "site2015|blog2015";

// --------------------------
// a-blog cms Ver. 2.6.0.2 設定
// --------------------------

# ダウンロード元 URL
$download55 = "http://ablogc.ms/1SODrck";
$download56 = "http://ablogc.ms/1UHnR5V";

# ダウンロード後のZipファイル名
$zipFile = "./acms2602_update2x.zip";

# 解凍後の全体フォルダ名
$zipAfterDirName = "acms2602_update2x";

# 解凍後の a-blog cms のフォルダ名
$cmsDirName = "ablogcms";

$installPath = realpath('.');

$ablogcmsDir = $installPath."/".$zipAfterDirName."/".$cmsDirName."/";

$phpName = basename($_SERVER['PHP_SELF']);

// --------------------------
// バージョンチェック
// --------------------------

$versionArray = explode(".", phpversion());
$version = $versionArray[0].".".$versionArray[1];

if ($versionArray[1] >= 6) { 
    $download = $download56;
} else { 
    $download = $download55;
}

// --------------------------
// a-blog cms ファイルをダウンロード
// --------------------------

$fp = fopen($download, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFile, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFile, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'a-blog cms download Error ! : '.$download;
    exit;
}

// --------------------------
// a-blog cms ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFile);
 
if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'a-blog cms unZip Error ! : '. $zipFile;
    exit;
}

// --------------------------
// バックアップ
// --------------------------

$backupDir = "backup_".date("YmdHis"); # = "backup_20151227102900";

# バックアップディレクトリを作成
mkdir($backupDir);

# ファイルを移動
if (is_file("./acms.js")) rename("./acms.js", $backupDir."/acms.js");
if (is_file("./index.js")) rename("./index.js", $backupDir."/index.js");
rename("./index.php", $backupDir."/index.php");

# ディレクトリを移動
dir_shori("move", "./js", $backupDir."/js");
dir_shori("move", "./lang", $backupDir."/lang");
dir_shori("move", "./php", $backupDir."/php");
dir_shori("move", "./private", $backupDir."/private");
dir_shori("move", "./themes", $backupDir."/themes");

// --------------------------
// update版 ファイル＆ディレクトリを移動
// --------------------------

dir_shori("move", $ablogcmsDir, $installPath);

# 運用中のものを利用するので新しいファイルは削除
unlink($installPath ."/htaccess.txt");

// --------------------------
// カスタマイズ部分を戻す
// --------------------------

# themes を戻す
if ($useThemes) {
if ($handle = opendir($backupDir."/themes")) {
  while(false !== ($theme = readdir($handle))) {
    if ($theme != "." && $theme != "..") {
      if (preg_match("/".$useThemes."/", $theme)) {
        if (is_dir("./themes/".$theme)) {
          rename ("./themes/".$theme, "./themes/".$theme."_".$cmsVersion);
        }
        dir_shori ("copy", $backupDir."/themes/".$theme, "./themes/".$theme);
      } 
    }
  }
  closedir($handle);
} 
}

# /php/ACMS/User を戻す
rename ("./php/ACMS/User","./php/ACMS/User_".$cmsVersion);
dir_shori ("copy", $backupDir."/php/ACMS/User", "./php/ACMS/User");        

# php/AAPP を戻す
rename ("./php/AAPP", "./php/AAPP_".$cmsVersion);
dir_shori ("copy", $backupDir."/php/AAPP", "./php/AAPP");  

# /private/config.system.yaml を戻す
rename ("./private/config.system.yaml", "./private/config.system_".$cmsVersion.".yaml");
copy ($backupDir."/private/config.system.yaml", "./private/config.system.yaml");  


// --------------------------
// .htaccess の設定
// --------------------------
rename("./private/htaccess.txt", './private/.htaccess');
rename("./themes/htaccess.txt", './themes/.htaccess');

// --------------------------
// php.ini があった時の処理
// --------------------------

if ( is_file( "./php.ini" )) {
    copy("./php.ini", "./setup/php.ini");
}

// --------------------------
// ファイルの削除
// --------------------------

unlink($zipFile);
unlink($phpName);

# プログラム以外のディレクトリを削除
dir_shori("delete", $zipAfterDirName);

// --------------------------
// インストーラーに飛ぶ
// --------------------------

$jump = str_replace($phpName, "", $_SERVER['SCRIPT_NAME']);
header("Location: " . $jump);

// --------------------------
// ディレクトリを操作 function ( move / copy / delete )
// --------------------------

function dir_shori ($shori, $nowDir , $newDir="") {

  if ($shori != "delete") {
    if (!is_dir($newDir)) {
      mkdir($newDir); 
    }
  }

  if (is_dir($nowDir)) {
    if ($handle = opendir($nowDir)) {
      while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
          if ($shori == "copy") {
            if (is_dir($nowDir."/".$file)) {
              dir_shori("copy", $nowDir."/".$file, $newDir."/".$file);
            } else {
              copy($nowDir."/".$file, $newDir."/".$file); 
            }
          } elseif ($shori == "move") {
            rename($nowDir."/".$file, $newDir."/".$file);
          } elseif ($shori == "delete") {
            if (filetype($nowDir."/".$file) == "dir") {
              dir_shori("delete", $nowDir."/".$file, ""); 
            } else {
              unlink($nowDir."/".$file); 
            } 
          }
        }
      }
      closedir($handle);
    }
  }

  if ($shori == "move" || $shori == "delete") {
    rmdir($nowDir);
  }

  return true;
}