<?php

// --------------------------
//
// NTT コミュニケーションズの Bizメール＆ウェブ 用 a-blog cms インストーラー
//
// --------------------------

# インストーラー の
# MySQL の設定を事前に行う場合に
# ここを設定してください。

$dbHost     = 'localhost';
$dbName     = 'DBacms';
$dbCreate   = 'checked';
$dbUser     = ''; # コンパネにログインするユーザーID
$dbPass     = ''; # コンパネで自分で設定したMySQLのパスワード

// --------------------------
// a-blog cms Ver. 2.6.0.2 設定
// --------------------------

# ダウンロード元 URL
$download55 = "http://ablogc.ms/1McmZ6v";
$download56 = "http://ablogc.ms/1MRodUF";

# ダウンロード後のZipファイル名
$zipFile = "./acms2602_install.zip";

# 解凍後の全体フォルダ名
$zipAfterDirName = "acms2602_install";

# 解凍後の a-blog cms のフォルダ名
$cmsDirName = "ablogcms";

# ioncube Loader ダウンロード元 URL
$downloadIoncube = "http://downloads3.ioncube.com/loader_downloads/ioncube_loaders_lin_x86-64.zip";

# ioncube Loader ダウンロード後のZipファイル名
$zipFileIoncube ="ioncube.zip";

$installPath = realpath('.');

$phpName = basename($_SERVER['PHP_SELF']);

// --------------------------
// バージョンのチェック
// --------------------------

$versionArray = explode(".", phpversion());
$version = $versionArray[0].".".$versionArray[1];

if ($versionArray[1] >= 6) { 
    $download = $download56;
} else { 
    $download = $download55;
}

$ablogcmsDir = $installPath."/".$zipAfterDirName."/".$cmsDirName."/";

// --------------------------
// バックアップ
// --------------------------


$backupDir = "backup_".date("YmdHis");

if (is_dir("./fonts")) {
  mkdir($backupDir);
  rename("./index.html", $backupDir."/index.html");
  copy("./.htaccess", $backupDir."/.htaccess");

  dir_shori ("move", "css", $backupDir."/css");
  dir_shori ("move", "fonts", $backupDir."/fonts");
  dir_shori ("move", "js", $backupDir."/js");
}

// --------------------------
// a-blog cms ファイルをダウンロード
// --------------------------

$fp = fopen($download, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFile, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFile, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'a-blog cms download Error ! : '.$download;
    exit;
}

// --------------------------
// a-blog cms ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFile);
 
if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'a-blog cms unZip Error ! : '. $zipFile;
    exit;
}




// --------------------------
// a-blog cms ディレクトリを移動
// --------------------------

if ($handle = opendir($ablogcmsDir)) {
    while(false !== ($entry = readdir($handle))) {
        if ($entry != "." && $entry != "..") {
             rename($ablogcmsDir.$entry, $installPath ."/". $entry);
        }
    }
    closedir($handle);
} else {
    echo 'a-blog cms move Error ! :'.$ablogcmsDir;
    exit;
}

// --------------------------
// ioncube ファイルをダウンロード
// --------------------------

$fp = fopen($downloadIoncube, "r");
if ($fp !== FALSE) {
    file_put_contents($zipFileIoncube, "");
    while(!feof($fp)) {
        $buffer = fread($fp, 4096);
        if ($buffer !== FALSE) {
            file_put_contents($zipFileIoncube, $buffer, FILE_APPEND);
        }
    }
    fclose($fp);
} else {
    echo 'ioncube loader download Error ! : '.$download;
    exit;
}

// --------------------------
// ioncube ファイルを解凍
// --------------------------

$zip = new ZipArchive();
$res = $zip->open($zipFileIoncube);
 
if($res === true){
    $zip->extractTo($installPath);
    $zip->close();

} else {
    echo 'ioncube loader unZip Error ! : '. $zipFileIoncube;
    exit;
}

// --------------------------
// php.ini の設定
// --------------------------


# htdocs の外に php.ini を置く

$iniFileName = "php.ini";
$phpiniDir = explode("/htdocs",$installPath);

if (!is_file($phpiniDir[0]."/".$iniFileName)) {
  $iniData = sprintf("date.timezone = 'Asia/Tokyo'\nzend_extension = \"%s/ioncube/ioncube_loader_lin_5.%d.so\"",$installPath,$versionArray[1]);
  file_put_contents($phpiniDir[0]."/".$iniFileName, $iniData, FILE_APPEND | LOCK_EX);
}

// --------------------------
// .htaccess の設定
// --------------------------

$moto_htaccessFile = ".htaccess";

if (!is_file($moto_htaccessFile)) {
    if (is_file($phpiniDir[0]."/htdocs/.htaccess")) {
        $moto_htaccessFile = $phpiniDir[0]."/htdocs/.htaccess";
    }
}

$htaccessData = file_get_contents($moto_htaccessFile);
$cms_htaccessData = file_get_contents("htaccess.txt");

#$file = file_get_contents($moto_htaccessFile);

$file = fopen( "./.htaccess", "w+" );
fwrite( $file, $htaccessData );
fwrite( $file, "\n\n".$cms_htaccessData );
fclose( $file );

rename("archives/htaccess.txt", 'archives/.htaccess');
rename("archives_rev/htaccess.txt", 'archives_rev/.htaccess');
rename("media/htaccess.txt", 'media/.htaccess');
rename("private/htaccess.txt", 'private/.htaccess');
rename("themes/htaccess.txt", 'themes/.htaccess');


// --------------------------
// DB 初期設定
// --------------------------
$data = sprintf("<?php
\$dbDefaultHost     = '%s';
\$dbDefaultName     = '%s';
\$dbDefaultCreate   = '%s'; // '' or 'checked'
\$dbDefaultUser     = '%s';
\$dbDefaultPass     = '%s';
\$dbDefaultPrefix   = 'acms_';",$dbHost,$dbName,$dbCreate,$dbUser,$dbPass);
$db_default = $installPath."/setup/lib/db_default.php";
file_put_contents($db_default, $data);

// --------------------------
// ファイルの削除
// --------------------------

unlink("htaccess.txt");

unlink($zipFile);
unlink($zipFileIoncube);
unlink($phpName);

unlink($installPath."/ioncube/loader-wizard.php");

# プログラム以外のディレクトリを削除
dir_shori("delete", $zipAfterDirName);

// --------------------------
// インストーラーに飛ぶ
// --------------------------

$jump = str_replace($phpName, "", $_SERVER['SCRIPT_NAME']);
header("Location: " . $jump);

// --------------------------
// ディレクトリを操作 function ( move / copy / delete )
// --------------------------
function dir_shori ($shori, $nowDir , $newDir="") {
  if ($shori != "delete") {
    if (!is_dir($newDir)) {
      mkdir($newDir); 
    }
  }
  if (is_dir($nowDir)) {
    if ($handle = opendir($nowDir)) {
      while (($file = readdir($handle)) !== false) {
        if ($file != "." && $file != "..") {
          if ($shori == "copy") {
            if (is_dir($nowDir."/".$file)) {
              dir_shori("copy", $nowDir."/".$file, $newDir."/".$file);
            } else {
              copy($nowDir."/".$file, $newDir."/".$file); 
            }
          } elseif ($shori == "move") {
            rename($nowDir."/".$file, $newDir."/".$file);
          } elseif ($shori == "delete") {
            if (filetype($nowDir."/".$file) == "dir") {
              dir_shori("delete", $nowDir."/".$file, ""); 
            } else {
              unlink($nowDir."/".$file); 
            } 
          }
        }
      }
      closedir($handle);
    }
  }
  if ($shori == "move" || $shori == "delete") {
    rmdir($nowDir);
  }
  return true;
}